
let compose f g x = f (g x);;

let (@@) = compose;;

let flip f x y = f y x;;

let id x = x;;

let const k x = k;;

let chfun f x a y = if x = y then a else f y;;

type label = int;;

let string_of_label = string_of_int;;

type abschan = int;;

let string_of_abschan = string_of_int;;

type channel_type = Secure | Authentic | Insecure;;

let chantype ach = if ach <= 10 then Secure else
                       if ach <= 20 then Authentic else Insecure;;

type ('h,'i) hexpr = Keypair of label
		   | SKpair of label
		   | Store of 'i
		   | MyList of 'h list
		   | HVar of 'h
		   | PubKey of 'h
		   | VerKey of 'h
		   | PubEnc of label * 'h * 'h
		   | PrivEnc of label * 'h * 'h
		   | Sign of label * 'h * 'h
		   | Proj of 'h * int * int
		   | SymKey of label * int
		   | PubDec of 'h * 'h
		   | PrivDec of 'h * 'h
		   | Nonce of label
		   | KeyOfSig of 'h
		   | MsgOfSig of 'h
and  ('h,'i) iexpr = Imm of int
		   | IVar of 'i
		   | Retrieve of 'h ;;

type ('h,'i) asgnment = ImmAsgn of 'i * ('h,'i) iexpr
		      | HndAsgn of 'h * ('h,'i) hexpr ;;

type ('h,'i) compared = ImmComp of 'i * 'i
		      | HndComp of 'h * 'h 
		      | Verify of 'h * 'h * 'h;; (* sig, key, msg *)

type ('h,'i) outProc = PStop of ('h,'i) inpProc list
		     | PII
		     | PSend of abschan * 'i * 'h * ('h,'i) inpProc list
		     | POutput of 'i * ('h, 'i) inpProc list
		     | PLet of label * ('h,'i) asgnment * ('h,'i) outProc * ('h,'i) outProc
		     | PLetZ of label * ('h,'i) asgnment * ('h,'i) outProc
		     | PLetI of label * ('h,'i) asgnment * ('h,'i) outProc
		     | PIf of label * ('h,'i) compared * ('h,'i) outProc * ('h,'i) outProc
		     | PIfZ of label * ('h,'i) compared * ('h,'i) outProc
		     | PIfI of label * ('h,'i) compared * ('h,'i) outProc
and  ('h,'i) inpProc = ('h,'i) iprefix * label * ('h,'i) outProc
and  ('h,'i) iprefix = IPSimple of ('h,'i) simpref
		     | IPReplic of ('h,'i) simpref
and  ('h,'i) simpref = PReceive of abschan * 'i * 'h
		     | PInput of 'i ;;

let nsa' kA kAinv pref n kX =
(IPReplic (PReceive (21, pref ^ "fc1", pref^"mc")), 0,
PIfI (0, HndComp (pref ^ "mc", kX),
PLetZ (0, HndAsgn (pref ^ "sA", Nonce 0),
PLetZ (0, HndAsgn (pref ^"anon1", MyList [pref ^ "sA"; kA]),
PLetZ (0, HndAsgn (pref^"anon2", PubEnc (0, kX, pref^"anon1")),
PSend (21, n, pref^"anon2", [
(IPSimple (PReceive (21, pref^"yX2", pref^"m2")), 0,
PLetI (0, HndAsgn (pref^"l2", PubDec (kAinv, pref^"m2")),
PLetI (0, HndAsgn (pref^"sA2", Proj (pref^"l2", 1, 3)),
PLetI (0, HndAsgn (pref^"kAX'", Proj (pref^"l2", 2, 3)),
PLetI (0, HndAsgn (pref^"kX2", Proj (pref^"l2", 3, 3)),
PIfI (0, HndComp (pref^"kX2", kX),
PIfI (0, HndComp (pref^"sA2", pref^"sA"),
PLetZ (0, HndAsgn (pref^"anon3", PubEnc(0, pref^"kX2", pref^"kAX'")),
PSend (21, n, pref^"anon3", [
(IPSimple (PReceive (21, pref^"yX4", pref^"m4")), 0,
PLetI (0, HndAsgn (pref^"s'", PrivDec(pref^"kAX'", pref^"m4")),
PLetI (0, ImmAsgn (pref^"anon4", Retrieve (pref^"s'")),
POutput (pref^"anon4",[]
))))]
)))))))))]
))))));;

let nsa =
(IPSimple (PInput "startA"), 0,
PLetZ (0, HndAsgn ("kAinv", Keypair 0),
PLetZ (0, ImmAsgn ("anon5", Imm 2),
PLetZ (0, HndAsgn ("kA$", PubKey "kAinv"),
PSend (11, "anon5", "kA$", [
(IPSimple (PReceive (12, "yB", "kB")), 0,
PIfI (0, ImmComp ("anon5", "yB"),
PStop [nsa' "kA$" "kAinv" "toB_" "yB" "kB"]
));
(IPReplic (PReceive (21, "yX1", "kX")), 0,
PStop [nsa' "kA$" "kAinv" "oth_" "yX1" "kX"]
)]
)))));;

let nsb =
(IPSimple (PInput "sI"), 0,
PLetZ (0, HndAsgn ("s", Store "sI"),
PLetZ (0, HndAsgn ("kBinv", Keypair 0),
PLetZ (0, HndAsgn ("kb$", PubKey "kBinv"),
PLetZ (0, ImmAsgn ("anon7", Imm 1),
PSend (12, "anon7", "kb$", [
(IPSimple (PReceive (11, "yA", "kA")), 0,
PIfI (0, ImmComp ("yA", "anon7"),
PStop [
(IPReplic (PReceive (21, "y1", "m1")), 0,
PLetI (0, HndAsgn ("l1", PubDec ("kBinv", "m1")),
PLetI (0, HndAsgn ("sA'", Proj ("l1", 1, 2)),
PLetI (0, HndAsgn ("kA2", Proj ("l1", 2, 2)),
PIfI (0, HndComp ("kA", "kA2"),
PLetZ (0, HndAsgn ("kAB", SymKey (0,1)),
PLetZ (0, HndAsgn ("anon8", MyList ["sA'"; "kAB"; "kb$"]),
PLetZ (0, HndAsgn ("anon9", PubEnc (0, "kA", "anon8")),
PSend (21, "anon7", "anon9", [
(IPSimple (PReceive (21, "y3", "m3")), 0,
PLetI (0, HndAsgn ("kAB2", PubDec ("kBinv", "m3")),
PIfI (0, HndComp ("kAB", "kAB2"),
PLetZ (0, HndAsgn ("anon10", PrivEnc (0, "kAB2", "s")),
PSend (21, "anon7", "anon10", []
)))))]
)))))))))]
))]
))))));;

let plusplus lbl =
  let t = !lbl
  in lbl := t + 1; t;;

let relabel oproc =
  let rec op_rl lbl oproc = match oproc with
    PStop ipl -> PStop (List.map (ip_rl lbl) ipl)
  | PII -> PII
  | PSend (ach,x,y,ipl) -> PSend (ach,x,y, List.map (ip_rl lbl) ipl)
  | POutput (x,ipl) -> POutput (x, List.map (ip_rl lbl) ipl)
  | PLet (_,asgn,pt,pf) -> PLet (plusplus lbl,
  	 (match asgn with
  	   ImmAsgn _ -> asgn
  	 | HndAsgn (x,e) -> HndAsgn (x, (match e with
  	 	Keypair _ -> Keypair (plusplus lbl)
  	      | PubEnc (_,k,t) -> PubEnc (plusplus lbl, k, t)
  	      | PrivEnc (_,k,t) -> PrivEnc (plusplus lbl, k, t)
  	      | SymKey (_,i) -> SymKey (plusplus lbl, i)
  	      | Nonce _ -> Nonce (plusplus lbl)
  	      | SKpair _ -> SKpair (plusplus lbl)
  	      | Sign (_,k,t) -> Sign (plusplus lbl, k, t)
  	      | _ -> e) ) ), (op_rl lbl pt), (op_rl lbl pf) )
  | PIf (_,cmp, pt, pf) -> PIf (plusplus lbl, cmp, (op_rl lbl pt), (op_rl lbl pf))
  | _ -> raise (Invalid_argument "call removeZI first")
  and ip_rl lbl (ipref, _, oproc) = (ipref, plusplus lbl, op_rl lbl oproc)
in op_rl (ref 1) oproc;;

let rec removeZI p =
  let iremoveZI (ipr,l,op) = (ipr, l,removeZI op)
  in match p with
      PStop ilist -> PStop (List.map iremoveZI ilist)
    | PII -> PII
    | PSend (c,a,v,ilist) -> PSend (c,a,v, List.map iremoveZI ilist)
    | POutput (v,ilist) -> POutput (v, List.map iremoveZI ilist)
    | PLet (l,a,p1,p2) -> PLet (l,a, removeZI p1, removeZI p2)
    | PLetZ (l,a,p1) -> PLet (l,a, removeZI p1, PStop [])
    | PLetI (l,a,p1) -> PLet (l,a, removeZI p1, PII)
    | PIf (l,c,p1,p2) -> PIf (l,c, removeZI p1, removeZI p2)
    | PIfZ (l,c,p1) -> PIf (l,c, removeZI p1, PStop [])
    | PIfI (l,c,p1) -> PIf (l,c, removeZI p1, PII) ;;

let ns = relabel (removeZI (PStop [nsa;nsb]));;

let ns2s =
(IPSimple (PReceive (14, "ssfc1", "sskA")), 0,
PLetZ (0, HndAsgn ("sssig", SKpair 0),
PLetZ (0, HndAsgn ("sszig", SKpair 0),
PLetZ (0, HndAsgn ("ssver", VerKey "sssig"),
PLetZ (0, HndAsgn ("sswer", VerKey "sszig"),
PLetZ (0, ImmAsgn ("ssAname", Imm 1),
PLetZ (0, ImmAsgn ("ssBname", Imm 2),
PSend (13, "ssAname", "ssver", [
(IPSimple (PReceive (15, "ssfc2", "sskB")), 0,
PSend (13, "ssBname", "sswer", [
(IPSimple (PReceive (21, "ssdm1", "ssdm2")), 0,
PLetZ (0, HndAsgn ("ssAsig", Sign (0, "sszig", "sskA")),
PLetZ (0, HndAsgn ("ssBsig", Sign (0, "sssig", "sskB")),
PSend (21, "ssAname", "ssBsig", [
(IPSimple (PReceive (21, "ssdm3", "ssdm4")), 0,
PSend (21, "ssBname", "ssAsig", []
))]
))))]
))]
))))))));;

let ns2a =
(IPSimple (PInput "startA"), 0,
PLetZ (0, HndAsgn ("kAinv", Keypair 0),
PLetZ (0, ImmAsgn ("yB", Imm 2),
PLetZ (0, ImmAsgn ("asName", Imm 0),
PLetZ (0, HndAsgn ("kA$", PubKey "kAinv"),
PSend (14, "asName", "kA$", [
(IPSimple (PReceive (13, "adum1", "asver")), 0,
PStop [
(IPSimple (PReceive (21, "adum2", "kBsigned")), 0,
PLetI (0, HndAsgn ("kB", MsgOfSig "kBsigned"),
PIfI (0, Verify ("kBsigned", "asver", "kB"),
PStop [nsa' "kA$" "kAinv" "toB_" "yB" "kB"]
)));
(IPReplic (PReceive (21, "yX1", "kX")), 0,
PStop [nsa' "kA$" "kAinv" "oth_" "yX1" "kX"]
)])]
))))));;

let ns2b =
(IPSimple (PInput "sI"), 0,
PLetZ (0, HndAsgn ("s", Store "sI"),
PLetZ (0, HndAsgn ("kBinv", Keypair 0),
PLetZ (0, HndAsgn ("kb$", PubKey "kBinv"),
PLetZ (0, ImmAsgn ("yA", Imm 1),
PLetZ (0, ImmAsgn ("bsName", Imm 0),
PSend (15, "bsName", "kb$", [
(IPSimple (PReceive (13, "bdum1", "bsver")), 0,
PStop [
(IPSimple (PReceive (21, "bdum2", "kAsigned")), 0,
PLetI (0, HndAsgn ("kA", MsgOfSig "kAsigned"),
PIfI (0, Verify ("kAsigned", "bsver", "kA"),
PStop [
(IPReplic (PReceive (21, "y1", "m1")), 0,
PLetI (0, HndAsgn ("l1", PubDec ("kBinv", "m1")),
PLetI (0, HndAsgn ("sA'", Proj ("l1", 1, 2)),
PLetI (0, HndAsgn ("kA2", Proj ("l1", 2, 2)),
PIfI (0, HndComp ("kA", "kA2"),
PLetZ (0, HndAsgn ("kAB", SymKey (0,1)),
PLetZ (0, HndAsgn ("anon8", MyList ["sA'"; "kAB"; "kb$"]),
PLetZ (0, HndAsgn ("anon9", PubEnc (0, "kA", "anon8")),
PSend (21, "anon7", "anon9", [
(IPSimple (PReceive (21, "y3", "m3")), 0,
PLetI (0, HndAsgn ("kAB2", PubDec ("kBinv", "m3")),
PIfI (0, HndComp ("kAB", "kAB2"),
PLetZ (0, HndAsgn ("anon10", PrivEnc (0, "kAB2", "s")),
PSend (21, "anon7", "anon10", []
)))))]
)))))))))]
)))])]
)))))));;

let ns2 = relabel (removeZI (PStop [ns2a;ns2b;ns2s]));;

let nsaorig' kA kAinv pref n kX =
(IPReplic (PReceive (21, pref ^ "fc1", pref^"mc")), 0,
PIfI (0, HndComp (pref ^ "mc", kX),
PLetZ (0, HndAsgn (pref ^ "sA", Nonce 0),
PLetZ (0, HndAsgn (pref ^"anon1", MyList [pref ^ "sA"; kA]),
PLetZ (0, HndAsgn (pref^"anon2", PubEnc (0, kX, pref^"anon1")),
PSend (21, n, pref^"anon2", [
(IPSimple (PReceive (21, pref^"yX2", pref^"m2")), 0,
PLetI (0, HndAsgn (pref^"l2", PubDec (kAinv, pref^"m2")),
PLetI (0, HndAsgn (pref^"sA2", Proj (pref^"l2", 1, 2)),
PLetI (0, HndAsgn (pref^"kAX'", Proj (pref^"l2", 2, 2)),
PIfI (0, HndComp (pref^"sA2", pref^"sA"),
PLetZ (0, HndAsgn (pref^"anon3", PubEnc(0, kX, pref^"kAX'")),
PSend (21, n, pref^"anon3", [
(IPSimple (PReceive (21, pref^"yX4", pref^"m4")), 0,
PLetI (0, HndAsgn (pref^"s'", PrivDec(pref^"kAX'", pref^"m4")),
PLetI (0, ImmAsgn (pref^"anon4", Retrieve (pref^"s'")),
POutput (pref^"anon4",[]
))))]
)))))))]
))))));;

let nsaorig =
(IPSimple (PInput "startA"), 0,
PLetZ (0, HndAsgn ("kAinv", Keypair 0),
PLetZ (0, ImmAsgn ("anon5", Imm 2),
PLetZ (0, HndAsgn ("kA$", PubKey "kAinv"),
PSend (11, "anon5", "kA$", [
(IPSimple (PReceive (12, "yB", "kB")), 0,
PIfI (0, ImmComp ("anon5", "yB"),
PStop [nsaorig' "kA$" "kAinv" "toB_" "yB" "kB"]
));
(IPReplic (PReceive (21, "yX1", "kX")), 0,
PStop [nsaorig' "kA$" "kAinv" "oth_" "yX1" "kX"]
)]
)))));;

let nsborig =
(IPSimple (PInput "sI"), 0,
PLetZ (0, HndAsgn ("s", Store "sI"),
PLetZ (0, HndAsgn ("kBinv", Keypair 0),
PLetZ (0, HndAsgn ("kb$", PubKey "kBinv"),
PLetZ (0, ImmAsgn ("anon7", Imm 1),
PSend (12, "anon7", "kb$", [
(IPSimple (PReceive (11, "yA", "kA")), 0,
PIfI (0, ImmComp ("yA", "anon7"),
PStop [
(IPReplic (PReceive (21, "y1", "m1")), 0,
PLetI (0, HndAsgn ("l1", PubDec ("kBinv", "m1")),
PLetI (0, HndAsgn ("sA'", Proj ("l1", 1, 2)),
PLetI (0, HndAsgn ("kA2", Proj ("l1", 2, 2)),
PIfI (0, HndComp ("kA", "kA2"),
PLetZ (0, HndAsgn ("kAB", SymKey (0,1)),
PLetZ (0, HndAsgn ("anon8", MyList ["sA'"; "kAB"]),
PLetZ (0, HndAsgn ("anon9", PubEnc (0, "kA", "anon8")),
PSend (21, "anon7", "anon9", [
(IPSimple (PReceive (21, "y3", "m3")), 0,
PLetI (0, HndAsgn ("kAB2", PubDec ("kBinv", "m3")),
PIfI (0, HndComp ("kAB", "kAB2"),
PLetZ (0, HndAsgn ("anon10", PrivEnc (0, "kAB2", "s")),
PSend (21, "anon7", "anon10", []
)))))]
)))))))))]
))]
))))));;

let nsorig = relabel (removeZI (PStop [nsaorig;nsborig]));;

let yahalomO oid rid okey pref =
(IPReplic (PInput (pref ^ "secr0")), 0,
PLetZ (0, HndAsgn (pref^"secr", Store (pref^"secr0")),
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetZ (0, HndAsgn (pref^"Na", Nonce 0),
PLetZ (0, HndAsgn (pref^"m1", MyList [pref^"oid"; pref^"Na"]),
PSend (21, rid, pref^"m1", [
(IPSimple (PReceive (21, pref^"dummy1", pref^"m3")), 0,
PLetI (0, HndAsgn (pref^"m3:1", Proj (pref^"m3", 1, 2)),
PLetI (0, HndAsgn (pref^"m3:2", Proj (pref^"m3", 2, 2)),
PLetI (0, HndAsgn (pref^"m3d", PrivDec (okey, pref^"m3:1")),
PLetI (0, HndAsgn (pref^"m3d1", Proj (pref^"m3d", 1, 4)),
PLetI (0, HndAsgn (pref^"m3d2", Proj (pref^"m3d", 2, 4)),
PLetI (0, HndAsgn (pref^"m3d3", Proj (pref^"m3d", 3, 4)),
PLetI (0, HndAsgn (pref^"m3d4", Proj (pref^"m3d", 4, 4)),
PIfI (0, HndComp (pref^"m3d1", pref^"rid"),
PIfI (0, HndComp (pref^"m3d3", pref^"Na"),
PLetZ (0, HndAsgn (pref^"m4:2", PrivEnc (0, pref^"m3d2", pref^"m3d4")),
PLetZ (0, HndAsgn (pref^"m4:3", PrivEnc (0, pref^"m3d2", pref^"secr")),
PLetZ (0, HndAsgn (pref^"m4", MyList [pref^"m3d4"; pref^"m4:2"; pref^"m4:3"]),
PSend (21, rid, pref^"m4", []
))))))))))))))]
)))))));;

let yahalomR oid rid rkey sid pref =
(IPReplic (PReceive (21, pref^"dummy1", pref^"m1")), 0,
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetZ (0, HndAsgn (pref^"sid", Store sid),
PLetI (0, HndAsgn (pref^"m11", Proj (pref^"m1", 1, 2)),
PLetI (0, HndAsgn (pref^"m12", Proj (pref^"m1", 2, 2)),
PIfI (0, HndComp (pref^"m11", pref^"oid"),
PLetZ (0, HndAsgn (pref^"Nb", Nonce 0),
PLetZ (0, HndAsgn (pref^"tri", MyList [pref^"oid";pref^"m12";pref^"Nb"]),
PLetZ (0, HndAsgn (pref^"m22", PrivEnc (0, rkey, pref^"tri")),
PLetZ (0, HndAsgn (pref^"m2", MyList [pref^"rid"; pref^"m22"]),
PSend (21, sid, pref^"m2", [
(IPSimple (PReceive (21, pref^"dummy2", pref^"m4")), 0,
PLetI (0, HndAsgn (pref^"m4:1", Proj (pref^"m4", 1, 3)),
PLetI (0, HndAsgn (pref^"m4:2", Proj (pref^"m4", 2, 3)),
PLetI (0, HndAsgn (pref^"m4:3", Proj (pref^"m4", 3, 3)),
PLetI (0, HndAsgn (pref^"m41d", PrivDec (rkey, pref^"m4:1")),
PLetI (0, HndAsgn (pref^"A", Proj (pref^"m41d", 1, 2)),
PLetI (0, HndAsgn (pref^"Kab", Proj (pref^"m41d", 2, 2)),
PIfI (0, HndComp (pref^"A", pref^"oid"),
PLetI (0, HndAsgn (pref^"Nb'", PrivDec (pref^"Kab", pref^"m4:2")),
PIfI (0, HndComp (pref^"Nb", pref^"Nb'"),
PLetI (0, HndAsgn (pref^"secr", PrivDec (pref^"Kab", pref^"m4:3")),
PLetI (0, ImmAsgn (pref^"secr0", Retrieve (pref^"secr")),
POutput (pref^"secr0", []
)))))))))))))]
))))))))))));;

let yahalomS23 oid rid okey rkey pref =
(IPReplic (PReceive (21, pref^"dummy1", pref^"m2")), 0,
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetI (0, HndAsgn (pref^"snd", Proj (pref^"m2", 1, 2)),
PLetI (0, HndAsgn (pref^"m22", Proj (pref^"m2", 2, 2)),
PIfI (0, HndComp (pref^"rid", pref^"snd"),
PLetI (0, HndAsgn (pref^"md", PrivDec (rkey, pref^"m22")),
PLetI (0, HndAsgn (pref^"A", Proj (pref^"md", 1, 3)),
PLetI (0, HndAsgn (pref^"Na", Proj (pref^"md", 2, 3)),
PLetI (0, HndAsgn (pref^"Nb", Proj (pref^"md", 3, 3)),
PLetZ (0, HndAsgn (pref^"Kab", SymKey (0,1)),
PLetZ (0, HndAsgn (pref^"toAd", MyList [pref^"rid"; pref^"Kab"; pref^"Na"; pref^"Nb"]),
PLetZ (0, HndAsgn (pref^"toBd", MyList [pref^"oid"; pref^"Kab"]),
PLetZ (0, HndAsgn (pref^"toA", PrivEnc (0, okey, pref^"toAd")),
PLetZ (0, HndAsgn (pref^"toB", PrivEnc (0, rkey, pref^"toBd")),
PLetZ (0, HndAsgn (pref^"m3", MyList [pref^"toA"; pref^"toB"]),
PSend (21, oid, pref^"m3", []
)))))))))))))))));;

let yahalomA = 
(IPSimple (PReceive (1, "Adummy1", "A::Kas")), 0,
PLetZ (0, ImmAsgn ("AA", Imm 1),
PLetZ (0, ImmAsgn ("AB", Imm 2),
PLetZ (0, ImmAsgn ("AS", Imm 0),
PStop [yahalomO "AA" "AB" "A::Kas" "A:AtoB_";
       yahalomR "AB" "AA" "A::Kas" "AS" "A:BtoA_"]
))));;

let yahalomB =
(IPSimple (PReceive (2, "Bdummy1", "B::Kbs")), 0,
PLetZ (0, ImmAsgn ("BA", Imm 1),
PLetZ (0, ImmAsgn ("BB", Imm 2),
PLetZ (0, ImmAsgn ("BS", Imm 0),
PStop [yahalomO "BB" "BA" "B::Kbs" "B:BtoA_";
       yahalomR "BA" "BB" "B::Kbs" "BS" "B:AtoB_"]
))));;

let yahalomS =
(IPSimple (PInput "Sdummy1"), 0,
PLetZ (0, ImmAsgn ("SA", Imm 1),
PLetZ (0, ImmAsgn ("SB", Imm 2),
PLetZ (0, HndAsgn ("S::Kas", SymKey (0,2)),
PLetZ (0, HndAsgn ("S::Kbs", SymKey (0,2)),
PSend (1, "SA", "S::Kas", [
(IPSimple (PInput "Sdummy2"), 0,
PSend (2, "SB", "S::Kbs",
[yahalomS23 "SA" "SB" "S::Kas" "S::Kbs" "S:AtoB_";
 yahalomS23 "SB" "SA" "S::Kbs" "S::Kas" "S:BtoA_"]
))]))))));;
 
let yahalom = relabel (removeZI (PStop [yahalomA; yahalomB; yahalomS]));;

let otreO oid rid sid okey pref =
(IPReplic (PInput (pref^"secr0")), 0,
PLetZ (0, HndAsgn (pref^"secr", Store (pref^"secr0")),
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetZ (0, HndAsgn (pref^"sid", Store sid),
PLetZ (0, HndAsgn (pref^"M", Nonce 0),
PLetZ (0, HndAsgn (pref^"Na", Nonce 0),
PLetZ (0, HndAsgn (pref^"m1ld", MyList [pref^"Na"; pref^"M"; pref^"oid"; pref^"rid"]),
PLetZ (0, HndAsgn (pref^"m1l", PrivEnc(0, okey, pref^"m1ld")),
PLetZ (0, HndAsgn (pref^"m1", MyList [pref^"M"; pref^"oid"; pref^"rid"; pref^"m1l"]),
PSend (21, rid, pref^"m1", [
(IPSimple (PReceive (21, pref^"dummy1", pref^"m4")), 0,
PLetI (0, HndAsgn (pref^"m41", Proj (pref^"m4", 1, 2)),
PIfI (0, HndComp (pref^"m41", pref^"M"),
PLetI (0, HndAsgn (pref^"m42", Proj (pref^"m4", 2, 2)),
PLetI (0, HndAsgn (pref^"m42d", PrivDec (okey, pref^"m42")),
PLetI (0, HndAsgn (pref^"Na2", Proj (pref^"m42d", 1, 2)),
PLetI (0, HndAsgn (pref^"Kab", Proj (pref^"m42d", 2, 2)),
PIfI (0, HndComp (pref^"Na", pref^"Na2"),
PLetZ (0, HndAsgn (pref^"em", PrivEnc (0, pref^"Kab", pref^"secr")),
PSend (21, rid, pref^"em", []
))))))))))]
)))))))))));;

let otreR oid rid sid rkey pref =
(IPReplic (PReceive (21, pref^"dummy1", pref^"m1")), 0,
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetZ (0, HndAsgn (pref^"sid", Store sid),
PLetI (0, HndAsgn (pref^"M", Proj (pref^"m1", 1, 4)),
PLetI (0, HndAsgn (pref^"thr1", Proj (pref^"m1", 4, 4)),
PLetZ (0, HndAsgn (pref^"Nb", Nonce 0),
PLetZ (0, HndAsgn (pref^"m25d", MyList [pref^"Nb"; pref^"M"; pref^"oid"; pref^"rid"]),
PLetZ (0, HndAsgn (pref^"m25", PrivEnc (0, rkey, pref^"m25d")),
PLetZ (0, HndAsgn (pref^"m2", MyList [pref^"M"; pref^"oid"; pref^"rid"; pref^"thr1"; pref^"m25"]),
PSend (21, sid, pref^"m2", [
(IPSimple (PReceive (21, pref^"dummy2", pref^"m3")), 0,
PLetI (0, HndAsgn (pref^"M2", Proj (pref^"m3", 1, 3)),
PLetI (0, HndAsgn (pref^"thr2", Proj (pref^"m3", 2, 3)),
PLetI (0, HndAsgn (pref^"m3x", Proj (pref^"m3", 3, 3)),
PIfI (0, HndComp (pref^"M", pref^"M2"),
PLetI (0, HndAsgn (pref^"m3d", PrivDec (rkey, pref^"m3x")),
PLetI (0, HndAsgn (pref^"Nb2", Proj (pref^"m3d", 1, 2)),
PLetI (0, HndAsgn (pref^"Kab", Proj (pref^"m3d", 2, 2)),
PLetZ (0, HndAsgn (pref^"m4", MyList [pref^"M"; pref^"thr2"]),
PSend (21, oid, pref^"m4", [
(IPSimple (PReceive (21, pref^"dummy3", pref^"em")), 0,
PLetI (0, HndAsgn (pref^"secr", PrivDec (pref^"Kab", pref^"em")),
PLetI (0, ImmAsgn (pref^"secr0", Retrieve (pref^"secr")),
POutput (pref^"secr0", []
))))]
))))))))))]
)))))))))));;

let otreS23 oid rid okey rkey pref =
(IPReplic (PReceive (21, pref^"dummy1", pref^"m2")), 0,
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetI (0, HndAsgn (pref^"frAe", Proj (pref^"m2", 4, 5)),
PLetI (0, HndAsgn (pref^"frBe", Proj (pref^"m2", 5, 5)),
PLetI (0, HndAsgn (pref^"frA", PrivDec (okey, pref^"frAe")),
PLetI (0, HndAsgn (pref^"frB", PrivDec (rkey, pref^"frBe")),
PLetI (0, HndAsgn (pref^"Na", Proj (pref^"frA", 1, 4)),
PLetI (0, HndAsgn (pref^"Nb", Proj (pref^"frB", 1, 4)),
PLetI (0, HndAsgn (pref^"M", Proj (pref^"frA", 2, 4)),
PLetI (0, HndAsgn (pref^"M'", Proj (pref^"frB", 2, 4)),
PIfI (0, HndComp (pref^"M", pref^"M'"),
PLetI (0, HndAsgn (pref^"oid1", Proj (pref^"frA", 3, 4)),
PLetI (0, HndAsgn (pref^"oid2", Proj (pref^"frB", 3, 4)),
PIfI (0, HndComp (pref^"oid", pref^"oid1"),
PIfI (0, HndComp (pref^"oid", pref^"oid2"),
PLetI (0, HndAsgn (pref^"rid1", Proj (pref^"frA", 4, 4)),
PLetI (0, HndAsgn (pref^"rid2", Proj (pref^"frB", 4, 4)),
PIfI (0, HndComp (pref^"rid", pref^"rid1"),
PIfI (0, HndComp (pref^"rid", pref^"rid2"),
PLetZ (0, HndAsgn (pref^"Kab", SymKey (0, 1)),
PLetZ (0, HndAsgn (pref^"toA", MyList [pref^"Na"; pref^"Kab"]),
PLetZ (0, HndAsgn (pref^"toB", MyList [pref^"Nb"; pref^"Kab"]),
PLetZ (0, HndAsgn (pref^"toAe", PrivEnc (0, okey, pref^"toA")),
PLetZ (0, HndAsgn (pref^"toBe", PrivEnc (0, rkey, pref^"toB")),
PLetZ (0, HndAsgn (pref^"m3", MyList [pref^"M"; pref^"toAe"; pref^"toBe"]),
PSend (21, rid, pref^"m3", []
)))))))))))))))))))))))))));;

let otreA = 
(IPSimple (PReceive (1, "Adummy1", "A::Kas")), 0,
PLetZ (0, ImmAsgn ("AA", Imm 1),
PLetZ (0, ImmAsgn ("AB", Imm 2),
PLetZ (0, ImmAsgn ("AS", Imm 0),
PStop [otreO "AA" "AB" "AS" "A::Kas" "A:AtoB_";
       otreR "AB" "AA" "AS" "A::Kas" "A:BtoA_"]
))));;

let otreB =
(IPSimple (PReceive (2, "Bdummy1", "B::Kbs")), 0,
PLetZ (0, ImmAsgn ("BA", Imm 1),
PLetZ (0, ImmAsgn ("BB", Imm 2),
PLetZ (0, ImmAsgn ("BS", Imm 0),
PStop [otreO "BB" "BA" "BS" "B::Kbs" "B:BtoA_";
       otreR "BA" "BB" "BS" "B::Kbs" "B:AtoB_"]
))));;

let otreS =
(IPSimple (PInput "Sdummy1"), 0,
PLetZ (0, ImmAsgn ("SA", Imm 1),
PLetZ (0, ImmAsgn ("SB", Imm 2),
PLetZ (0, HndAsgn ("S::Kas", SymKey (0,2)),
PLetZ (0, HndAsgn ("S::Kbs", SymKey (0,2)),
PSend (1, "SA", "S::Kas", [
(IPSimple (PInput "Sdummy2"), 0,
PSend (2, "SB", "S::Kbs",
[otreS23 "SA" "SB" "S::Kas" "S::Kbs" "S:AtoB_";
 otreS23 "SB" "SA" "S::Kbs" "S::Kas" "S:BtoA_"]
))]))))));;
 
let otwayrees = relabel (removeZI (PStop [otreA; otreB; otreS]));;

let banyahalO oid rid okey pref =
(IPReplic (PInput (pref ^ "secr0")), 0,
PLetZ (0, HndAsgn (pref^"secr", Store (pref^"secr0")),
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetZ (0, HndAsgn (pref^"Na", Nonce 0),
PLetZ (0, HndAsgn (pref^"m1", MyList [pref^"oid"; pref^"Na"]),
PSend (21, rid, pref^"m1", [
(IPSimple (PReceive (21, pref^"dummy1", pref^"m3")), 0,
PLetI (0, HndAsgn (pref^"m3:1", Proj (pref^"m3", 2, 3)),
PLetI (0, HndAsgn (pref^"m3:2", Proj (pref^"m3", 3, 3)),
PLetI (0, HndAsgn (pref^"m3d", PrivDec (okey, pref^"m3:1")),
PLetI (0, HndAsgn (pref^"m3d1", Proj (pref^"m3d", 1, 3)),
PLetI (0, HndAsgn (pref^"m3d2", Proj (pref^"m3d", 2, 3)),
PLetI (0, HndAsgn (pref^"m3d3", Proj (pref^"m3d", 3, 3)),
PLetI (0, HndAsgn (pref^"m3d4", Proj (pref^"m3", 1, 3)),
PIfI (0, HndComp (pref^"m3d1", pref^"rid"),
PIfI (0, HndComp (pref^"m3d3", pref^"Na"),
PLetZ (0, HndAsgn (pref^"m4:2", PrivEnc (0, pref^"m3d2", pref^"m3d4")),
PLetZ (0, HndAsgn (pref^"m4:3", PrivEnc (0, pref^"m3d2", pref^"secr")),
PLetZ (0, HndAsgn (pref^"m4", MyList [pref^"m3d4"; pref^"m4:2"; pref^"m4:3"]),
PSend (21, rid, pref^"m4", []
))))))))))))))]
)))))));;

let banyahalR oid rid rkey sid pref =
(IPReplic (PReceive (21, pref^"dummy1", pref^"m1")), 0,
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetZ (0, HndAsgn (pref^"sid", Store sid),
PLetI (0, HndAsgn (pref^"m11", Proj (pref^"m1", 1, 2)),
PLetI (0, HndAsgn (pref^"m12", Proj (pref^"m1", 2, 2)),
PIfI (0, HndComp (pref^"m11", pref^"oid"),
PLetZ (0, HndAsgn (pref^"Nb", Nonce 0),
PLetZ (0, HndAsgn (pref^"tri", MyList [pref^"oid";pref^"m12"]),
PLetZ (0, HndAsgn (pref^"m22", PrivEnc (0, rkey, pref^"tri")),
PLetZ (0, HndAsgn (pref^"m2", MyList [pref^"rid"; pref^"Nb"; pref^"m22"]),
PSend (21, sid, pref^"m2", [
(IPSimple (PReceive (21, pref^"dummy2", pref^"m4")), 0,
PLetI (0, HndAsgn (pref^"m4:1", Proj (pref^"m4", 1, 3)),
PLetI (0, HndAsgn (pref^"m4:2", Proj (pref^"m4", 2, 3)),
PLetI (0, HndAsgn (pref^"m4:3", Proj (pref^"m4", 3, 3)),
PLetI (0, HndAsgn (pref^"m41d", PrivDec (rkey, pref^"m4:1")),
PLetI (0, HndAsgn (pref^"A", Proj (pref^"m41d", 1, 3)),
PLetI (0, HndAsgn (pref^"Kab", Proj (pref^"m41d", 2, 3)),
PLetI (0, HndAsgn (pref^"Nb2", Proj (pref^"m41d", 3, 3)),
PIfI (0, HndComp (pref^"Nb", pref^"Nb2"),
PIfI (0, HndComp (pref^"A", pref^"oid"),
PLetI (0, HndAsgn (pref^"Nb'", PrivDec (pref^"Kab", pref^"m4:2")),
PIfI (0, HndComp (pref^"Nb", pref^"Nb'"),
PLetI (0, HndAsgn (pref^"secr", PrivDec (pref^"Kab", pref^"m4:3")),
PLetI (0, ImmAsgn (pref^"secr0", Retrieve (pref^"secr")),
POutput (pref^"secr0", []
)))))))))))))))]
))))))))))));;

let banyahalS23 oid rid okey rkey pref =
(IPReplic (PReceive (21, pref^"dummy1", pref^"m2")), 0,
PLetZ (0, HndAsgn (pref^"oid", Store oid),
PLetZ (0, HndAsgn (pref^"rid", Store rid),
PLetI (0, HndAsgn (pref^"snd", Proj (pref^"m2", 1, 3)),
PLetI (0, HndAsgn (pref^"m22", Proj (pref^"m2", 3, 3)),
PIfI (0, HndComp (pref^"rid", pref^"snd"),
PLetI (0, HndAsgn (pref^"md", PrivDec (rkey, pref^"m22")),
PLetI (0, HndAsgn (pref^"A", Proj (pref^"md", 1, 2)),
PLetI (0, HndAsgn (pref^"Na", Proj (pref^"md", 2, 2)),
PLetI (0, HndAsgn (pref^"Nb", Proj (pref^"m2", 2, 3)),
PLetZ (0, HndAsgn (pref^"Kab", SymKey (0,1)),
PLetZ (0, HndAsgn (pref^"toAd", MyList [pref^"rid"; pref^"Kab"; pref^"Na"]),
PLetZ (0, HndAsgn (pref^"toBd", MyList [pref^"oid"; pref^"Kab"; pref^"Nb"]),
PLetZ (0, HndAsgn (pref^"toA", PrivEnc (0, okey, pref^"toAd")),
PLetZ (0, HndAsgn (pref^"toB", PrivEnc (0, rkey, pref^"toBd")),
PLetZ (0, HndAsgn (pref^"m3", MyList [pref^"Nb"; pref^"toA"; pref^"toB"]),
PSend (21, oid, pref^"m3", []
)))))))))))))))));;

let banyahalA = 
(IPSimple (PReceive (1, "Adummy1", "A::Kas")), 0,
PLetZ (0, ImmAsgn ("AA", Imm 1),
PLetZ (0, ImmAsgn ("AB", Imm 2),
PLetZ (0, ImmAsgn ("AS", Imm 0),
PStop [banyahalO "AA" "AB" "A::Kas" "A:AtoB_";
       banyahalR "AB" "AA" "A::Kas" "AS" "A:BtoA_"]
))));;

let banyahalB =
(IPSimple (PReceive (2, "Bdummy1", "B::Kbs")), 0,
PLetZ (0, ImmAsgn ("BA", Imm 1),
PLetZ (0, ImmAsgn ("BB", Imm 2),
PLetZ (0, ImmAsgn ("BS", Imm 0),
PStop [banyahalO "BB" "BA" "B::Kbs" "B:BtoA_";
       banyahalR "BA" "BB" "B::Kbs" "BS" "B:AtoB_"]
))));;

let banyahalS =
(IPSimple (PInput "Sdummy1"), 0,
PLetZ (0, ImmAsgn ("SA", Imm 1),
PLetZ (0, ImmAsgn ("SB", Imm 2),
PLetZ (0, HndAsgn ("S::Kas", SymKey (0,2)),
PLetZ (0, HndAsgn ("S::Kbs", SymKey (0,2)),
PSend (1, "SA", "S::Kas", [
(IPSimple (PInput "Sdummy2"), 0,
PSend (2, "SB", "S::Kbs",
[banyahalS23 "SA" "SB" "S::Kas" "S::Kbs" "S:AtoB_";
 banyahalS23 "SB" "SA" "S::Kbs" "S::Kas" "S:BtoA_"]
))]))))));;
 
let banyahal = relabel (removeZI (PStop [banyahalA; banyahalB; banyahalS]));;

let prcn = List.fold_left Pretty.concat Pretty.nil

let fstprot = PLetZ (1, HndAsgn ("kinv", Keypair 2), 
	      PLetZ (3, HndAsgn ("k", PubKey "kinv"),
	      PLetZ (6, ImmAsgn ("a", Imm 4),
	      PLetZ (7, ImmAsgn ("b", Imm 7),
	      PLetZ (8, HndAsgn ("M", Store "b"),
	      PLetZ (4, HndAsgn ("eM", PubEnc (5, "k", "M")),
	      PSend (2, "a", "eM", [])))))));;

let id x = x;;

(* let () = print_string (printOP 0 id id (removeZI fstprot));; *)

type abstrVal = XP
	      | XS
	      | AStore of abstrVal
	      | ANonce of label * bool list
	      | ASymkey of int * label * bool list
	      | ASymkeyname of label * bool list
	      | ASeckey of label * bool list
	      | APubkey of label * bool list
	      | ASigkey of label * bool list
	      | AVerkey of label * bool list
	      | ASignature of abstrVal * abstrVal
	      | AList of abstrVal list
	      | APubenc of abstrVal * abstrVal * label * bool list
	      | ASymenc of abstrVal * abstrVal * label * bool list
	      | AnyPubVal
	      | Alive;;

let rec intersperse l k = match l with
  [] -> []
| [_] -> l
| (x::xs) -> x :: k :: (intersperse xs k);;

let string_of_sl l = List.fold_left (^) "" (intersperse l ", ");;

let string_of_bl b = string_of_sl (List.map string_of_bool b);;

let rec string_of_av av = match av with
  XP -> "XP"
| XS -> "XS"
| AStore x -> "AStore (" ^ (string_of_av x) ^ ")"
| ANonce (l,b) -> "ANonce (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| ASymkey (i,l,b) -> "ASymkey (" ^ (string_of_int i) ^ ", " ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| ASymkeyname (l,b) -> "ASymkeyname (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| APubkey (l,b) -> "APubkey (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| ASeckey (l,b) -> "ASeckey (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| ASigkey (l,b) -> "ASigkey (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| AVerkey (l,b) -> "AVerkey (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| AList hl -> "AList [" ^ string_of_sl (List.map string_of_av hl) ^ "]"
| APubenc (k,t,l,b) -> "APubenc (" ^ (string_of_av k) ^ ", " ^ (string_of_av t) ^ ", " ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| ASymenc (k,t,l,b) -> "ASymenc (" ^ (string_of_av k) ^ ", " ^ (string_of_av t) ^ ", " ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| ASignature (k,t) -> "ASignature (" ^ (string_of_av k) ^ ", " ^ (string_of_av t) ^ "])"
| AnyPubVal -> "AnyPubVal"
| Alive -> "Alive";;

let rec prettyav av = 
  let pl x = List.fold_right Pretty.concat x Pretty.nil
  and prcs d = Pretty.seq ~sep:(Pretty.concat (Pretty.chr ',') Pretty.break)
                  ~doit:id ~elements:d
  in let prbl bl = pl [Pretty.text "["; 
                         prcs (List.map (Pretty.text @@ string_of_bool) bl);
                         Pretty.text "]"]
  and prpar d = pl [Pretty.text "("; d; Pretty.text ")"]
  and prlab = Pretty.text @@ string_of_label
  in let prpars = prpar @@ prcs
  and prname s d = 
(*       let s1 = String.sub s 0 2
       and s2 = String.sub s 2 ((String.length s) - 2)
       in pl [Pretty.text s1; Pretty.align; Pretty.text s2; d; Pretty.unalign]
*)
    pl [Pretty.text s; Pretty.align; d; Pretty.unalign]
in match av with
  XP -> Pretty.text "XP"
| XS -> Pretty.text "XS"
| AStore x -> prname "Store" (prpar (prettyav x))
| ANonce (l,b) -> prname "Nonce" (prpars [prlab l; prbl b])
| ASymkey (i,l,b) -> prname "Symkey" (prpars [Pretty.num i; prlab l; prbl b])
| ASymkeyname (l,b) -> prname "SKname" (prpars [prlab l; prbl b])
| APubkey (l,b) -> prname "Pubkey" (prpars [prlab l; prbl b])
| ASeckey (l,b) -> prname "Seckey" (prpars [prlab l; prbl b])
| ASigkey (l,b) -> prname "Sigkey" (prpars [prlab l; prbl b])
| AVerkey (l,b) -> prname "Verkey" (prpars [prlab l; prbl b])
| AList hl -> prname "List" (pl [Pretty.text "[";
      prcs (List.map prettyav hl); Pretty.text "]"])
| APubenc (k,t,l,b) -> prname "Pubenc" (prpars [prettyav k; prettyav t;
                                                prlab l; prbl b])
| ASymenc (k,t,l,b) -> prname "Symenc" (prpars [prettyav k; prettyav t;
                                                prlab l; prbl b])
| ASignature (k,t) -> prname "Signature" (prpars [prettyav k; prettyav t])
| AnyPubVal -> Pretty.text "AnyPubVal"
| Alive -> Pretty.text "Alive";;

let rec string_of_boollist bl = match bl with
  []	 -> ""
| (b::bs) -> (if b then "1" else "0") ^ (string_of_boollist bs);;

type ('h,'i) constrVar = VVI of label * bool list
		       | VVF of label * bool * bool list
		       | VVStart
		       | VC of abschan
		       | VP
		       | VE of label * bool list
		       | VS of label * bool list
		       | VL of label * bool * bool list
		       | VLStart
		       | VDummy;;

(*
type ('h,'i) inConVar = VXh of 'h
		      | VXi of 'i ;;

let iCVToXml icv = match icv with
  VXh h -> Xml.Element ("ICVhandle", [("name", h)], [])
| VXi h -> Xml.Element ("ICVimmediate", [("name", h)], []);;
*)

let string_of_cv cv = match cv with
  VC ach -> "VC " ^ (string_of_abschan ach)
| VP -> "VP"
| VE (l,b) -> "VE (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| VS (l,b) -> "VS (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| VL (l,d,b) -> "VL (" ^ (string_of_label l) ^ ", " ^ (string_of_bool d) ^ ", [" ^ (string_of_bl b) ^ "])"
| VLStart -> "VLStart"
| VDummy -> "VDummy"
| VVI (l,b) -> "VVI (" ^ (string_of_label l) ^ ", [" ^ (string_of_bl b) ^ "])"
| VVF (l,d,b) -> "VVF (" ^ (string_of_label l) ^ ", " ^ (string_of_bool d) ^ ", [" ^ (string_of_bl b) ^ "])"
| VVStart -> "VVStart";;

module AbsVal : Set.OrderedType with type t = abstrVal =
struct
  type t = abstrVal
  let compare = Pervasives.compare
end

module AbsValSet =
struct
  include Set.Make(AbsVal)
  let copy x = x
  let hash = Hashtbl.hash
  let avspretty ld rd x = List.fold_right Pretty.concat
     [Pretty.text ld;
      Pretty.seq (Pretty.concat (Pretty.chr ',') Pretty.line)
                                                prettyav (elements x);
      Pretty.text rd] Pretty.nil
  let map f s = fold (add @@ f) s empty
  let from_list l = List.fold_right add l empty
  let mapl f s = fold (union @@ from_list @@ f) s empty
  let flatten = List.fold_left union empty
  let short n s = Pretty.sprint n (avspretty "<" ">" s)
end

let rec lcart sls = match sls with
  [] -> [[]]
| (s::ss) -> let c = lcart ss in
      List.concat (List.map (fun e -> List.map (fun cl -> (e::cl)) c) s);;

let rec avsintersect av1 av2 = if av1 = av2 then [av1] else
  if av1 = AnyPubVal then (match av2 with
  	  ASeckey _ | ASigkey _ -> []
  	| _ -> [av2] ) else
  if av2 = AnyPubVal then (match av1 with
  	  ASeckey _ | ASigkey _ -> []
  	| _ -> [av1]) else
 match av1,av2 with
    AList hl1, AList hl2 ->
    	if (List.length hl1) <> (List.length hl2) then [] else
		List.map (fun x -> AList x)
				 (lcart (List.map2 avsintersect hl1 hl2))
  | APubenc (k1,t1,l1,b1), APubenc (k2,t2,l2,b2) when l1=l2 && b1=b2 ->
  	let ks = avsintersect k1 k2
  	and ts = avsintersect t1 t2
  	in let kts = lcart [ks;ts]
        in List.map (function [k;t] -> APubenc (k,t,l1,b1)) kts
  | ASymenc (k1,t1,l1,b1), ASymenc (k2,t2,l2,b2) when l1=l2 && b1=b2 ->
  	let ks = avsintersect k1 k2
  	and ts = avsintersect t1 t2
  	in let kts = lcart [ks;ts]
  	in List.map (function [k;t] -> ASymenc (k,t,l1,b1)) kts
  | ASignature (k1,t1), ASignature (k2,t2) ->
  	let ks = avsintersect k1 k2
  	and ts = avsintersect t1 t2
  	in let kts = lcart [ks;ts]
  	in List.map (function [k;t] -> ASignature (k,t)) kts
  | _,_ -> [] ;;

let rec avsincludes av1 av2 = if av1 = av2 then true else
  if av2 = AnyPubVal then (match av1 with
               ASeckey _ | ASigkey _ -> false
             | _ -> true) else
  match av1,av2 with
     AList hl1, AList hl2 ->
         if (List.length hl1) <> (List.length hl2) then false else
             List.for_all2 avsincludes hl1 hl2
   | APubenc (k1,t1,l1,b1), APubenc (k2,t2,l2,b2) when l1=l2 && b1=b2 ->
       (avsincludes k1 k2) && (avsincludes t1 t2)
   | ASymenc (k1,t1,l1,b1), ASymenc (k2,t2,l2,b2) when l1=l2 && b1=b2 ->
       (avsincludes k1 k2) && (avsincludes t1 t2)
   | ASignature (k1,t1), ASignature (k2,t2) ->
       (avsincludes k1 k2) && (avsincludes t1 t2)
   | _,_ -> false;;

module AVSup =
struct
  include AbsValSet
  let leq = subset
  let join = union
  let meet = inter
  let bot () = empty
  let top () = raise Lattice.Unsupported
  let pretty () = avspretty "{" "}"
  let short n s = Pretty.sprint n (pretty () s)
end

module AVSdown =
struct
  include AbsValSet
  let leq s1 s2 = AbsValSet.for_all (fun x ->
                         AbsValSet.exists (avsincludes x) s1) s2
  let join s1 s2 = let res = mapl (fun x -> 
  		List.concat (List.map (avsintersect x) (elements s2))) s1
in
(*
print_newline ();
print_string "AVSdown.join:\n";
print_string ("arg1 = " ^ (short 0 s1) ^ "\n");
print_string ("arg2 = " ^ (short 0 s2) ^ "\n");
print_string ("res = " ^ (short 0 res) ^ "\n");
*)
res
  let meet = union
  let thebottomval = ref (empty)
  let bot () = !thebottomval
  let top () = empty
  let pretty () = avspretty "{|" "|}"
  let short n s = Pretty.sprint n (pretty () s)
end

let vscart sls = lcart (List.map AbsValSet.elements sls);;

module Var : Hashtbl.HashedType with type t = (string,string) constrVar =
struct
  type t = (string, string) constrVar
  let equal = (=)
  let hash = Hashtbl.hash
end

module IVar : Printable.S with type t = string =
struct
  type t = string
  let copy x = x
  let equal x y = (x=y)
  let hash = Hashtbl.hash
  let compare = Pervasives.compare
  let pretty () = Pretty.text
end

module ODom = Lattice.InfMap (IVar) (AVSup);;

module Solver = WorklistCon.Make (Var) (ODom);;

module ISolver = WorklistCon.Make (IVar) (AVSdown);;

let is_enc : (label * bool list -> AbsValSet.t) ref = 
                            ref (const AbsValSet.empty);;

let is_sig : (label * bool list -> AbsValSet.t) ref = 
                            ref (const AbsValSet.empty);;

let rec equivp pset t1 t2 =
let rec equivp' pset t1 t2 = if t1 = t2 then true else
  match t1,t2 with
    AStore u1, AStore u2 -> equivp pset u1 u2
  | XS, XP -> true
  | XP, XS -> true
  | _, AnyPubVal when AbsValSet.mem t1 pset -> true
  | AList hl1, AList hl2 -> (try List.for_all2 (equivp pset) hl1 hl2
                            with Invalid_argument _ -> false)
  | APubenc (k1,t1,l1,b1), APubenc (k2,t2,l2,b2) ->
      l1 = l2 && b1 = b2 && (equivp pset k1 k2) && (equivp pset t1 t2)
  | ASymenc (k1,t1,l1,b1), ASymenc (k2,t2,l2,b2) ->
      l1 = l2 && b1 = b2 && (equivp pset k1 k2) && (equivp pset t1 t2)
  | ASignature (k1,t1), ASignature (k2,t2) ->
      (equivp pset k1 k2) && (equivp pset t1 t2)
  | AStore XP, AnyPubVal -> true
  | AList hl, AnyPubVal when List.for_all (equivp pset AnyPubVal) hl -> true
(*
  | Alist hl, AnyPubVal when
      List.for_all (fun x -> AbsValSet.exists (equivp pset x) pset) hl -> true
*)
  | APubenc (k,t,l,b), AnyPubVal when
      AbsValSet.exists (function x -> match x with
                          APubenc (kk,tt,ll,bb) -> ll = l && bb = b &&
                                                   (equivp pset kk k) &&
                                                   (equivp pset tt t)
                        | _ -> false) pset -> true
  | ASymenc (k,t,l,b), AnyPubVal when
      AbsValSet.exists (function x -> match x with
                          ASymenc (kk,tt,ll,bb) -> ll = l && bb = b &&
                                                   (equivp pset kk k) &&
                                                   (equivp pset tt t)
                          | _ -> false) pset -> true
  | ASignature (k,t), AnyPubVal when
      AbsValSet.exists (function x -> match x with
                          ASignature (kk,tt) ->    (equivp pset kk k) &&
                                                   (equivp pset tt t)
                        | _ -> false) pset -> true
  | AnyPubVal, _ -> equivp pset t2 t1
  | _, _ -> false
(*
in print_string ("Applying equivp to " ^ (AbsValSet.short 0 pset) ^ " and " ^ (string_of_av t1) ^ " and " ^ (string_of_av t2) ^ " ...");
print_newline ();
let res = equivp' pset t1 t2
in print_string ("... giving " ^ (string_of_bool res)); print_newline (); res;;
*)
in equivp' pset t1 t2  
  
(*absemhe : (string,string) hexpr -> 
            (string -> Var.t) ->
            bool list ->
            string ->
            Var.t -> Solver.rhs list*)
let absemhe expr b lhs sl clhs = match expr with
  Keypair l -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
               [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                             (AbsValSet.singleton (ASeckey (l, b)))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [] )
| SKpair l -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
               [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                             (AbsValSet.singleton (ASigkey (l, b)))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [] )
| Store i -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
               [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                     (AbsValSet.map (fun x -> AStore x)
                                 (ODom.find (a (VVI (sl,b))) i))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| MyList hl -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
               [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                  (AbsValSet.from_list (List.map (fun x -> AList x)
                      (vscart (List.map (ODom.find (a (VVI (sl,b)))) hl))))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| HVar h -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
                     [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                                     (ODom.find (a (VVI (sl,b))) h)]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| PubKey h -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
             let f x = match x with
                                  ASeckey (l,b) -> [APubkey (l,b)]
                                | _ -> []
            in [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                           (AbsValSet.mapl f (ODom.find (a (VVI (sl,b))) h))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| VerKey h -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
             let f x = match x with
                                  ASigkey (l,b) -> [AVerkey (l,b)]
                                | _ -> []
            in [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                           (AbsValSet.mapl f (ODom.find (a (VVI (sl,b))) h))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| Nonce l -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
               [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                             (AbsValSet.singleton (ANonce (l, b)))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [] )
| SymKey (l,i) -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
               [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                             (AbsValSet.singleton (ASymkey (i, l, b)))]
    | _ -> [] )
| Proj (h,i,j) -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
              let f x = match x with
                         AList hl -> if (List.length hl) == j
                                       then [List.nth hl (i-1)]
                                       else []
                       | AnyPubVal -> [AnyPubVal]
                       | _ -> []
              in [fun a -> ODom.replace (a (VVI (sl,b))) lhs (
                        AbsValSet.mapl f (ODom.find (a (VVI (sl,b))) h))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| KeyOfSig h -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
              let f x = match x with
                         ASignature (k,_) -> [k]
                       | AnyPubVal -> [AnyPubVal]
                       | _ -> []
              in [fun a -> ODom.replace (a (VVI (sl,b))) lhs (
                        AbsValSet.mapl f (ODom.find (a (VVI (sl,b))) h))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| MsgOfSig h -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
              let f x = match x with
                         ASignature (_,t) -> [t]
                       | AnyPubVal -> [AnyPubVal]
                       | _ -> []
              in [fun a -> ODom.replace (a (VVI (sl,b))) lhs (
                        AbsValSet.mapl f (ODom.find (a (VVI (sl,b))) h))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| PubEnc(l,k,t) -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
            [(fun a ->
                let eks = AbsValSet.elements (AbsValSet.filter
                                (function (APubkey _) -> true
                                    |	  _ -> false) (ODom.find (a (VVI (sl,b))) k))
                in ODom.replace (a (VVI (sl,b))) lhs 
                        (AbsValSet.mapl (fun x -> List.map
                                      (fun y -> APubenc (y,x,l,b)) eks)
                                  (ODom.find (a (VVI (sl,b))) t)));
             (fun a -> ODom.replace (a (VVI (sl,b))) lhs
                      (if AbsValSet.mem AnyPubVal (ODom.find (a (VVI (sl,b))) k)
                      then AbsValSet.map (fun x -> APubenc (AnyPubVal,x,l,b))
                                         (ODom.find (a (VVI (sl,b))) t)
                      else AbsValSet.empty))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | VE (l2,b2) ->
           [fun a -> (ODom.M.empty,
               if AbsValSet.mem (APubkey (l2,b2)) (ODom.find (a (VVI (sl,b))) k)
               then ODom.find (a (VVI (sl,b))) t
               else AbsValSet.empty)]
    | _ -> [])
| Sign(l,k,t) -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
            [(fun a ->
                let eks = AbsValSet.elements (AbsValSet.filter
                                (function (ASigkey _) -> true
                                    |	  _ -> false) (ODom.find (a (VVI (sl,b))) k))
                in ODom.replace (a (VVI (sl,b))) lhs 
                        (AbsValSet.mapl (fun x -> List.map
                                      (function ASigkey (skl,skb) ->
                                         ASignature (AVerkey (skl,skb),x)) eks)
                                  (ODom.find (a (VVI (sl,b))) t)))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | VS (l2,b2) ->
           [fun a -> (ODom.M.empty,
               if AbsValSet.mem (ASigkey (l2,b2)) (ODom.find (a (VVI (sl,b))) k)
               then ODom.find (a (VVI (sl,b))) t
               else AbsValSet.empty)]
    | _ -> [])
| PrivEnc(l,k,t) -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
            [(fun a ->
                let eks = AbsValSet.elements (AbsValSet.filter
                                (function (ASymkey _) -> true
                                    |	  _ -> false) (ODom.find (a (VVI (sl,b))) k))
                in ODom.replace (a (VVI (sl,b))) lhs 
                        (AbsValSet.mapl (fun x -> List.map
                                      (fun y -> ASymenc (y,x,l,b)) eks)
                                  (ODom.find (a (VVI (sl,b))) t)));
             (fun a -> ODom.replace (a (VVI (sl,b))) lhs
                      (if AbsValSet.mem AnyPubVal (ODom.find (a (VVI (sl,b))) k)
                      then AbsValSet.map (fun x -> ASymenc (AnyPubVal,x,l,b))
                                         (ODom.find (a (VVI (sl,b))) t)
                      else AbsValSet.empty))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | VE (l2,b2) ->
           [fun a -> (ODom.M.empty,
               if AbsValSet.exists
                     (function ASymkey (_,ll,bb) -> ll=l2 && bb=b2
                       |       _ -> false) (ODom.find (a (VVI (sl,b))) k)
               then ODom.find (a (VVI (sl,b))) t
               else AbsValSet.empty)]
    | _ -> [])
| PubDec (k,t) -> (match clhs with
      VVF (_l,true,true::_b) when sl = _l && b = _b ->
            [(fun a ->
                let f x = match x with
                            APubenc(APubkey(ll,bb),pt,_,_) ->
                             if AbsValSet.mem (ASeckey (ll,bb)) (ODom.find (a (VVI (sl,b))) k)
                             then [pt]
                             else []
                            | _ -> []
                in ODom.replace (a (VVI (sl,b))) lhs
                     (AbsValSet.mapl f (ODom.find (a (VVI (sl,b))) t)));
             (fun a ->ODom.replace (a (VVI (sl,b))) lhs 
                      (if AbsValSet.mem AnyPubVal (ODom.find (a (VVI (sl,b))) t)
                      then AbsValSet.flatten (
                          List.map (function (ASeckey (ll,bb)) ->
                                                        snd (a (VE (ll,bb)))
                                      | _ -> AbsValSet.empty)
                                     (AbsValSet.elements (ODom.find (a (VVI (sl,b))) k)))
                      else AbsValSet.empty))]
    | VVF (_l,true,false::_b) when sl = _l && b = _b ->
            [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                         (if AbsValSet.mem AnyPubVal
                                   (ODom.find (a (VVI (sl,b))) t)
                          then AbsValSet.singleton AnyPubVal
                          else AbsValSet.empty)]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| PrivDec (k,t) -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
            [(fun a ->
                let f x = match x with
                            ASymenc(kk,pt,_,_) ->
                             if AbsValSet.exists (equivp (snd (a VP)) kk)
                                              (ODom.find (a (VVI (sl,b))) k)
                             then [pt]
                             else []
                            | _ -> []
                in ODom.replace (a (VVI (sl,b))) lhs
                     (AbsValSet.mapl f (ODom.find (a (VVI (sl,b))) t)));
             (fun a ->ODom.replace (a (VVI (sl,b))) lhs 
                      (if AbsValSet.mem AnyPubVal (ODom.find (a (VVI (sl,b))) t)
                      then AbsValSet.flatten (
                          List.map (function (ASymkey (_,ll,bb)) ->
                                                        snd (a (VE (ll,bb)))
                                      | _ -> AbsValSet.empty)
                                     (AbsValSet.elements (ODom.find (a (VVI (sl,b))) k)))
                      else AbsValSet.empty));
            (fun a -> ODom.replace (a (VVI (sl,b))) lhs
               (if AbsValSet.mem AnyPubVal (ODom.find (a (VVI (sl,b))) t) &&
                   AbsValSet.exists (equivp (snd (a VP)) AnyPubVal)
                                           (ODom.find (a (VVI (sl,b))) k)
                then AbsValSet.singleton AnyPubVal
                else AbsValSet.empty))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> []);;

let absemie expr b lhs sl clhs = match expr with
  Imm n -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
               [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                             (AbsValSet.singleton XP)]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [] )
| IVar i -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
                     [fun a -> ODom.replace (a (VVI (sl,b))) lhs
                                     (ODom.find (a (VVI (sl,b))) i)]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> [])
| Retrieve h -> (match clhs with
      VVF (_l,true,_b) when sl = _l && b = _b ->
            [(fun a -> ODom.replace (a (VVI (sl,b))) lhs
                   (AbsValSet.mapl
                       (function (AStore x) -> [x]
                            | _ -> []) (ODom.find (a (VVI (sl,b))) h)) );
             (fun a -> ODom.replace (a (VVI (sl,b))) lhs
                       (if AbsValSet.mem AnyPubVal
                                       (ODom.find (a (VVI (sl,b))) h)
                       then AbsValSet.singleton XP
                       else AbsValSet.empty))]
    | VVF (_l,false,_b) when sl=_l && b=_b ->
                [fun a -> a (VVI (sl,b))]
    | _ -> []);;

let destructterm pset av = match av with
  AStore av' -> [av']
| AList hl -> hl
| ASymenc (k,t,_,_) -> (if AbsValSet.exists (equivp pset k) pset
                       then [t] else []) @
                       (match k with
                          ASymkey (_,l,b) -> [ASymkeyname (l,b)]
                        | _ -> []
                       )
| APubenc (k,t,_,_) -> k :: if  k = AnyPubVal then [t] else []
| ASignature (k,t) -> [k;t]
| _ -> [];;

let advpower vvv = match vvv with
  VP -> [fun a -> let pset = snd (a VP)
                  in (ODom.M.empty, AbsValSet.add XP (AbsValSet.add AnyPubVal (
                     AbsValSet.mapl (destructterm pset) pset)))    ]
| _ -> [];;

let rec fromto k l = if k>l then [] else k :: (fromto (k+1) l);;

let downhs expr b lhs clhs = match expr with
  MyList hl -> let hlen = List.length hl in (match clhs with
    _l when _l = lhs ->
        [fun a -> AbsValSet.from_list (List.map (fun x -> AList x)
                                                 (vscart (List.map a hl)))]
  | z when List.mem z hl ->
        [fun a -> List.fold_left (fun s (i,zz) ->
          if zz=z then AbsValSet.union s 
            (AbsValSet.mapl (function AList gl when (List.length gl) = hlen ->
                                                              [List.nth gl i]
                              | AnyPubVal -> [AnyPubVal]
                              | _ -> []) (a lhs))
          else s) AbsValSet.empty (List.combine (fromto 0 (hlen-1)) hl)]
  | _ -> [])
| Proj (h,i,j) -> (match clhs with
    _l when _l = lhs ->
       [fun a -> AbsValSet.mapl 
           (function AList gl when (List.length gl) = j ->
                       [List.nth gl (i-1)]
              | AnyPubVal -> [AnyPubVal]
              | _ -> []) (a h)]
  | _l when _l = h ->
       [fun a -> AbsValSet.mapl
           (function AList gl when (List.length gl) = j ->
              let f x = if x = i-1
                        then List.concat (List.map
                                (avsintersect (List.nth gl x))
                                     (AbsValSet.elements (a lhs)))
                        else [List.nth gl x]
              in List.map (fun x -> AList x)
                    (lcart (List.map f (fromto 0 (j-1))))
            | AnyPubVal ->
              let f x = if x = i-1
                        then List.concat (List.map
                                (avsintersect AnyPubVal)
                                     (AbsValSet.elements (a lhs)))
                        else [AnyPubVal]
              in List.map (fun x -> AList x)
                    (lcart (List.map f (fromto 0 (j-1))))
            | _ -> [] ) (a h)]
  | _ -> [])
| KeyOfSig h -> (match clhs with
    _l when _l = lhs ->
       [fun a -> AbsValSet.mapl 
           (function ASignature (k,_) -> [k]
              | AnyPubVal -> [AnyPubVal]
              | _ -> []) (a h)]
  | _l when _l = h ->
       [fun a -> AbsValSet.mapl
           (function ASignature (k,t) ->
              let kls = List.concat (List.map (avsintersect k)
                                         (AbsValSet.elements (a lhs)))
              in List.map (fun k -> ASignature (k,t)) kls
            | AnyPubVal ->
                List.map (fun k -> ASignature (k,AnyPubVal))
                  (AbsValSet.elements (a lhs))
            | _ -> [] ) (a h)]
  | _ -> [])
| MsgOfSig h -> (match clhs with
    _l when _l = lhs ->
       [fun a -> AbsValSet.mapl 
           (function ASignature (k,t) ->
             (match k with
               AVerkey (ll,bb) ->
                       List.concat (List.map (avsintersect t)
                                  (AbsValSet.elements (!is_sig (ll,bb))))
             | _ -> [t])  
              | AnyPubVal -> [AnyPubVal]
              | _ -> []) (a h)]
  | _l when _l = h ->
       [fun a -> AbsValSet.mapl
           (function ASignature (k,t) ->
              let tls = List.concat (List.map (avsintersect t)
                                         (AbsValSet.elements (a lhs)))
              in List.map (fun t -> ASignature (k,t)) tls
            | AnyPubVal ->
                List.map (fun t -> ASignature (AnyPubVal,t))
                  (AbsValSet.elements (a lhs))
            | _ -> [] ) (a h)]
  | _ -> [])
| PubDec (k,t) -> if List.hd b = true then
                     (match clhs with
    _l when _l = lhs ->
       [fun a -> AbsValSet.mapl 
                    (function ASeckey (l,b) -> AbsValSet.elements (!is_enc (l,b))
                      | AnyPubVal -> (AbsValSet.elements (a lhs))
                      | _ -> []) (a k)]
  | _ -> [])
                  else []
| HVar h -> (match clhs with
    _l when _l = lhs ->
        [fun a -> a h]
  | _l when _l = h ->
        [fun a -> a lhs]
  | _ -> [])
| PubKey h -> (match clhs with
    _l when _l = lhs ->
        [fun a -> AbsValSet.mapl (function ASeckey (ll,bb) -> [APubkey(ll,bb)]
                                   | _ -> []) (a h)]
  | _l when _l = h ->
        [fun a -> AbsValSet.mapl (function APubkey (ll,bb) -> [ASeckey(ll,bb)]
                                   | _ -> []) (a lhs)]
  | _ -> [])
| VerKey h -> (match clhs with
    _l when _l = lhs ->
        [fun a -> AbsValSet.mapl (function ASigkey (ll,bb) -> [AVerkey(ll,bb)]
                                   | _ -> []) (a h)]
  | _l when _l = h ->
        [fun a -> AbsValSet.mapl (function AVerkey (ll,bb) -> [ASigkey(ll,bb)]
                                   | _ -> []) (a lhs)]
  | _ -> [])
| Store i -> (match clhs with
    _l when _l = lhs ->
        [fun a -> AbsValSet.map (fun x -> AStore x) (a i)]
  | _l when _l = i ->
        [fun a -> AbsValSet.mapl (function AStore x -> [x]
                                  | AnyPubVal -> [XP]
                                  | _ -> []) (a lhs)]
  | _ -> [])
| PubEnc (l,k,t) -> (match clhs with
    _l when _l = lhs ->
        [fun a -> AbsValSet.mapl 
            (fun kt -> List.map (fun tt -> APubenc (kt,tt,l,b))
                                    (AbsValSet.elements (a t))) (a k)]
  | _l when _l = k ->
        [fun a -> if AbsValSet.mem AnyPubVal (a lhs)
                  then (a k)
                  else AbsValSet.mapl
                         (function APubenc (kt,tt,_,_) ->
                                   if AbsValSet.exists (avsincludes tt) (a t)
                                   then [kt]
                                   else []
                               | _ -> []) (a lhs)]
  | _l when _l = t ->
        [fun a -> if AbsValSet.mem AnyPubVal (a lhs)
                  then (a t)
                  else AbsValSet.mapl
                         (function APubenc (kt,tt,_,_) ->
                                   if AbsValSet.exists (avsincludes kt) (a k)
                                   then [tt]
                                   else []
                               | _ -> []) (a lhs)]
  | _ -> [])
| Sign (_,k,t) -> (match clhs with
    _l when _l = lhs ->
        [fun a -> AbsValSet.mapl 
            (function ASigkey (ktl,ktb) -> 
                List.map (fun tt -> ASignature (AVerkey (ktl,ktb),tt))
                                    (AbsValSet.elements (a t))) (a k)]
  | _l when _l = t ->
        [fun a -> if AbsValSet.mem AnyPubVal (a lhs)
                  then (a t)
                  else AbsValSet.mapl
                         (function ASignature (AVerkey (ktl,ktb),tt) ->
                                   if AbsValSet.exists 
                                       (avsincludes (ASigkey (ktl,ktb))) (a k)
                                   then [tt]
                                   else []
                               | _ -> []) (a lhs)]
  | _ -> [])
| PrivEnc (l,k,t) -> (match clhs with
    _l when _l = lhs ->
        [fun a -> AbsValSet.mapl 
            (fun kt -> List.map (fun tt -> ASymenc (kt,tt,l,b))
                                   (AbsValSet.elements (a t))) (a k)]
  | _l when _l = k ->
        [fun a -> if AbsValSet.mem AnyPubVal (a lhs)
                  then (a k)
                  else AbsValSet.mapl
                         (function ASymenc (kt,tt,_,_) ->
                                   if AbsValSet.exists (avsincludes tt) (a t)
                                   then [kt]
                                   else []
                               | _ -> []) (a lhs)]
  | _l when _l = t ->
        [fun a -> if AbsValSet.mem AnyPubVal (a lhs)
                  then (a t)
                  else AbsValSet.mapl
                         (function ASymenc (kt,tt,_,_) ->
                                   if AbsValSet.exists (avsincludes kt) (a k)
                                   then [tt]
                                   else []
                               | _ -> []) (a lhs)]
  | _ -> [])
| PrivDec (k,t) ->(match clhs with
    _l when _l = lhs ->
       [fun a -> AbsValSet.mapl 
                    (function ASymkey (_,l,b) -> AbsValSet.elements (!is_enc (l,b))
                      | AnyPubVal -> (AbsValSet.elements (a lhs))
                      | _ -> []) (a k)]
  | _ -> [])
| _ -> [];;

let downis expr b lhs clhs = match expr with
  Retrieve h -> (match clhs with
    _l when _l = lhs ->
       [fun a -> AbsValSet.mapl (function AStore x -> [x]
                                  | AnyPubVal -> [XP]
                                  | _ -> []) (a h)]
  | _l when _l = h ->
       [fun a -> AbsValSet.add AnyPubVal
                  (AbsValSet.map (fun x -> AStore x) (a lhs))]
  | _ -> [])
| IVar h ->(match clhs with
    _l when _l = lhs ->
        [fun a -> a h]
  | _l when _l = h ->
        [fun a -> a lhs]
  | _ -> [])
| Imm _ -> [];;

let downhf expr b clhs = match expr with
  Keypair _ | SKpair _ | Store _ | SymKey _ | Nonce _ | HVar _ | MyList _ ->
                                   [fun _ -> AbsValSet.empty]
| PubKey h -> (match clhs with
    _l when _l = h ->
      [fun a -> AbsValSet.filter
                  (function ASeckey _ -> false
                    | _ -> true) (a h)]
  | _ -> [])
| VerKey h -> (match clhs with
    _l when _l = h ->
      [fun a -> AbsValSet.filter
                  (function ASigkey _ -> false
                    | _ -> true) (a h)]
  | _ -> [])
| Proj (h,_,j) -> (match clhs with
    _l when _l = h ->
       [ fun a -> AbsValSet.filter
                     (function AList hl when List.length hl = j -> false
                       | _ -> true) (a h)]
  | _ -> [])
| KeyOfSig h | MsgOfSig h -> (match clhs with
    _l when _l = h ->
       [ fun a -> AbsValSet.filter
                     (function ASignature (_,_) -> false
                       | _ -> true) (a h)]
  | _ -> [])
| _ -> [];;

let downif expr b clhs = match expr with
  Imm _ | IVar _ -> [fun _ -> AbsValSet.empty]
| Retrieve h -> (match clhs with
    _l when _l = h ->
      [fun a -> AbsValSet.filter
                  (function AStore _ -> false
                    | _ -> true) (a h)]
  | _ -> []);;
    

let absemhs expr avar = match expr with
  MyList hl -> List.for_all ((
         AbsValSet.exists (function ASeckey _ -> false | _ -> true)) @@ avar) hl
| Proj (h,_,j) -> AbsValSet.exists (
			function AnyPubVal -> true
			 |       AList xx -> (List.length xx == j)
			 |       _ -> false) (avar h)
| PubKey h -> AbsValSet.exists (
			function ASeckey _ -> true
			 |	 _ -> false) (avar h)
| VerKey h -> AbsValSet.exists (
			function ASigkey _ -> true
			 |	 _ -> false) (avar h)
| PubEnc (_,k,_) -> AbsValSet.exists (
			function APubkey _ -> true
			 |	 AnyPubVal -> true
			 |	 _ -> false) (avar k)
| PrivEnc (_,k,_) -> AbsValSet.exists (
			function ASymkey _ -> true
			 |	 AnyPubVal -> true
			 |	 _ -> false) (avar k)
| PrivDec (k,_) -> AbsValSet.exists (
			function ASymkey _ -> true
			 |	 AnyPubVal -> true
			 |	 _ -> false) (avar k)
| PubDec (k,_) -> AbsValSet.exists (
			function ASeckey _ -> true
			 |	 _ -> false) (avar k)
| Sign (_,k,_) -> AbsValSet.exists (
			function ASigkey _ -> true
			 |	 _ -> false) (avar k)
| _ -> true;;
  
let absemhf expr avar = match expr with
  Keypair _ -> false
| Store _ -> false
| MyList hl -> List.exists ((
         AbsValSet.exists (function ASeckey _ -> true | _ -> false)) @@ avar) hl
| SymKey _ -> false
| Proj (h,_,j) -> AbsValSet.exists (
			function AList xx -> (List.length xx <> j)
			 |       _ -> true) (avar h)
| PubKey h -> AbsValSet.exists (
			function ASeckey _ -> false
			 |	 _ -> true) (avar h)
| VerKey h -> AbsValSet.exists (
			function ASigkey _ -> false
			 |	 _ -> true) (avar h)
| Nonce _ -> false
| HVar _ -> false
| _ -> true;;

let absemis expr avar = match expr with
  Retrieve h -> AbsValSet.exists (
  			function AStore _ -> true
  			 |	 AnyPubVal -> true
  			 |	 _ -> false) (avar h)
| _ -> true;;
  
let absemif expr avar = match expr with
  Retrieve h -> AbsValSet.exists (
  			function AStore _ -> false
  			 |	 _ -> true) (avar h)
| _ -> false;;

let funion c1 c2 = fun v -> (c1 v) @ (c2 v);;

let ispubdec asgn = match asgn with
  HndAsgn (_,e) -> (match e with
      PubDec _ -> true
    | _ -> false)
| _ -> false;;

(*makeoutgoing:
  IVar.t list ->
  (IVar.t -> ((IVar.t -> AbsValSet.t) -> AbsValSet.t) list) ->
  ((Var.t -> (IVar.t => AbsValSet.t)) -> (IVar.t => AbsValSet.t)) ->
  (Var.t -> (IVar.t => AbsValSet.t)) -> (IVar.t => AbsValSet.t)
*)
let makeoutgoing vlist iconstrs origrhs oasgn =
let inp = origrhs oasgn in
let res =
begin
  ISolver.initstate := (fun x -> let res = ODom.find inp x in
  begin
  (*
  print_newline ();
  print_string ("Initstate called:\n" ^ x ^ " -> " ^ (AVSdown.short 80 res) ^ "\n");
  *)
  res
  end);
  is_enc := (fun (l,b) -> snd (oasgn (VE (l,b))));
  is_sig := (fun (l,b) -> snd (oasgn (VS (l,b))));
  let solu = ISolver.solve iconstrs vlist
  in (ISolver.HT.fold ODom.M.add solu ODom.M.empty, AbsValSet.empty)
end in
(*
print_newline ();
print_string "makeoutgoing: input is\n";
print_string (Pretty.sprint 80 (ODom.pretty () inp));
print_newline ();
print_string "Number of constraints:\n";
List.iter (fun x -> 
print_string (x ^ " has " ^ (string_of_int (List.length (iconstrs x))) ^ " constraints\n") ) vlist;
print_string "output is\n";
print_string (Pretty.sprint 80 (ODom.pretty () res));
print_newline (); print_newline ();
*)
res;;

let rec absemop b icvar vlist iconstrs liv proc clhs = match proc with
  PStop ipl ->
    List.concat (List.map (fun ip -> absemip b icvar vlist iconstrs liv ip clhs) ipl)
| PII -> []
| PSend (ach,xp,x,ipl) ->
    (absemop b icvar vlist iconstrs liv (PStop ipl) clhs) @
    (if clhs = VP then [fun a -> (ODom.M.empty, 
                                 if AbsValSet.mem Alive (snd (a liv))
                                 then ODom.find (a icvar) xp
                                 else AbsValSet.empty)]
     else []) @
    (if clhs = VC ach && (chantype ach = Secure || chantype ach = Authentic)
     then [fun a -> (ODom.M.empty,
                    if AbsValSet.mem Alive (snd (a liv))
                    then ODom.find (a icvar) x
                    else AbsValSet.empty)]
     else []) @
    (if clhs = VP && (chantype ach = Authentic || chantype ach = Insecure)
     then [fun a -> (ODom.M.empty,
                    if AbsValSet.mem Alive (snd (a liv))
                    then ODom.find (a icvar) x
                    else AbsValSet.empty)]
     else [])
| POutput (x,ipl) -> (absemop b icvar vlist iconstrs liv (PStop ipl) clhs)
| PLet (l,asgn,pt,pf) -> let pubdec = ispubdec asgn in (match asgn with
  HndAsgn (x,e) -> 
  if pubdec then
    let iconstrstt = funion (downhs e (true::b) x) iconstrs
    and iconstrstf = funion (downhs e (false::b) x) iconstrs
    and iconstrsf = funion (downhf e b) iconstrs
    and nvlist = x :: vlist
    in (match clhs with
      VL (_l,true,_b) when _l=l && _b=b ->
        [fun a -> (ODom.M.empty,
                  if AbsValSet.mem Alive (snd (a liv)) &&
                                  absemhs e (ODom.find (a icvar))
                  then AbsValSet.singleton Alive
                  else AbsValSet.empty)]
    | VL (_l,false,_b) when _l=l && _b=b ->
        [fun a -> (ODom.M.empty,
                  if AbsValSet.mem Alive (snd (a liv)) &&
                                  absemhf e (ODom.find (a icvar))
                  then AbsValSet.singleton Alive
                  else AbsValSet.empty)]
    | VVI (_l,_b) when _l=l && _b=b -> [fun a -> a icvar]
    | VVF (_l,true,true::_b) when _l=l && _b=b ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                  then makeoutgoing nvlist iconstrstt f a
                  else (ODom.M.empty, AbsValSet.empty))
                  (absemhe e b x l clhs)
    | VVF (_l,true,false::_b) when _l=l && _b=b ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                  then makeoutgoing nvlist iconstrstf f a
                  else (ODom.M.empty, AbsValSet.empty))
                  (absemhe e b x l clhs)
    | VVF (_,false,_) ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,false,b))))
                  then makeoutgoing vlist iconstrsf f a
                  else (ODom.M.empty, AbsValSet.empty))
                  (absemhe e b x l clhs)
    | _ -> List.map (fun f ->
                      fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                               then f a
                               else (ODom.M.empty,AbsValSet.empty))
                                (absemhe e b x l clhs)) @
    (absemop b (VVF (l,false,b)) vlist iconstrsf (VL (l,false,b)) pf clhs) @
    (absemop (true::b) (VVF (l,true,true::b)) nvlist iconstrstt (VL (l,true,b)) pt clhs) @
    (absemop (false::b) (VVF (l,true,false::b)) nvlist iconstrstf (VL (l,true,b)) pt clhs)
  else
    let iconstrst = funion (downhs e b x) iconstrs
    and iconstrsf = funion (downhf e b) iconstrs
    and nvlist = x :: vlist
    in (match clhs with
      VL (_l,true,_b) when _l=l && _b=b ->
        [fun a -> (ODom.M.empty,
                  if AbsValSet.mem Alive (snd (a liv)) &&
                                  absemhs e (ODom.find (a icvar))
                  then AbsValSet.singleton Alive
                  else AbsValSet.empty)]
    | VL (_l,false,_b) when _l=l && _b=b ->
        [fun a -> (ODom.M.empty,
                  if AbsValSet.mem Alive (snd (a liv)) &&
                                  absemhf e (ODom.find (a icvar))
                  then AbsValSet.singleton Alive
                  else AbsValSet.empty)]
    | VVI (_l,_b) when _l=l && _b=b -> [fun a -> a icvar]
    | VVF (_,true,_) ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                  then makeoutgoing nvlist iconstrst f a
                  else (ODom.M.empty, AbsValSet.empty))
                  (absemhe e b x l clhs)
    | VVF (_,false,_) ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,false,b))))
                  then makeoutgoing vlist iconstrsf f a
                  else (ODom.M.empty, AbsValSet.empty))
                  (absemhe e b x l clhs)
    | _ -> List.map (fun f ->
                      fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                               then f a
                               else (ODom.M.empty,AbsValSet.empty))
                                (absemhe e b x l clhs)) @
    (absemop b (VVF (l,false,b)) vlist iconstrsf (VL (l,false,b)) pf clhs) @
    (absemop b (VVF (l,true,b)) nvlist iconstrst (VL (l,true,b)) pt clhs)
| ImmAsgn (x,e) ->
    let iconstrst = funion (downis e b x) iconstrs
    and iconstrsf = funion (downif e b) iconstrs
    and nvlist = x :: vlist
    in (match clhs with
      VL (_l,true,_b) when _l=l && _b=b ->
        [fun a -> (ODom.M.empty,
                  if AbsValSet.mem Alive (snd (a liv)) &&
                                  absemis e (ODom.find (a icvar))
                  then AbsValSet.singleton Alive
                  else AbsValSet.empty)]
    | VL (_l,false,_b) when _l=l && _b=b ->
        [fun a -> (ODom.M.empty,
                  if AbsValSet.mem Alive (snd (a liv)) &&
                                  absemif e (ODom.find (a icvar))
                  then AbsValSet.singleton Alive
                  else AbsValSet.empty)]
    | VVI (_l,_b) when _l=l && _b=b -> [fun a -> a icvar]
    | VVF (_,true,_) ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                  then makeoutgoing nvlist iconstrst f a
                  else (ODom.M.empty, AbsValSet.empty))
                  (absemie e b x l clhs)
    | VVF (_,false,_) ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,false,b))))
                  then makeoutgoing vlist iconstrsf f a
                  else (ODom.M.empty, AbsValSet.empty))
                  (absemie e b x l clhs)
    | _ -> List.map (fun f ->
                      fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                               then f a
                               else (ODom.M.empty,AbsValSet.empty))
                                (absemie e b x l clhs)) @
    (absemop b (VVF (l,false,b)) vlist iconstrsf (VL (l,false,b)) pf clhs) @
    (absemop b (VVF (l,true,b)) nvlist iconstrst (VL (l,true,b)) pt clhs) )
| PIf (l,cmpd,pt,pf) -> (
  match cmpd with
    ImmComp _ | HndComp _ ->
    (
    let (x,x') = match cmpd with
                    ImmComp (y,y') -> (y,y')
                  | HndComp (y,y') -> (y,y')
                  | _ -> raise (Failure "we cannot reach this")
    in
    let iconstrst = funion iconstrs
         (fun z -> if z = x then [fun a -> a x']
                   else if z = x' then [fun a -> a x]
                        else [])
    in
    (absemop b (VVF (l,true,b)) vlist iconstrst (VL (l,true,b)) pt clhs) @
    (absemop b (VVF (l,false,b)) vlist iconstrs (VL (l,false,b)) pf clhs) @
    (match clhs with
        VL (_l,true,_b) when _l=l && _b=b ->
          [fun a -> (ODom.M.empty,
                    if AbsValSet.mem Alive (snd (a liv)) &&
                      let aicvar = a icvar in
                      AbsValSet.exists (
                        fun av -> AbsValSet.exists (equivp (snd (a VP)) av)
                                                   (ODom.find (aicvar) x')
                          ) (ODom.find (aicvar) x)
                    then AbsValSet.singleton Alive
                    else AbsValSet.empty)]
      | VL (_l,false,_b) when _l=l && _b=b ->
          [fun a -> (ODom.M.empty,
                    if AbsValSet.mem Alive (snd (a liv))
                    then AbsValSet.singleton Alive
                    else AbsValSet.empty)]
      | VVI (_l,_b) when _l=l && _b=b -> [fun a -> a icvar]
      | VVF (_l,true,_b) when _l=l && _b=b ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                  then makeoutgoing vlist iconstrst f a
                  else (ODom.M.empty, AbsValSet.empty))
                  [fun a -> a (VVI (l,b))]
      | VVF (_l,false,_b) when _l=l && _b=b ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,false,b))))
                  then f a
                  else (ODom.M.empty, AbsValSet.empty))
                  [fun a -> a (VVI (l,b))]
      | _ -> [])
    )
    | Verify (sigt,key,msg) ->
      let iconstrst = funion iconstrs (
        fun z -> 
          if z = key then [fun a -> 
                            AbsValSet.filter
                              (function AVerkey _ -> true
                                 | AnyPubVal -> true
                                 | _ -> false) (a key)]
          else if z = msg then [fun a ->
                 AbsValSet.mapl
                   (function AVerkey (l,b) ->
                         AbsValSet.elements (!is_sig (l,b))
                       | AnyPubVal -> AbsValSet.elements (a msg)
                       | _ -> [] ) (a key)]
          else if z = sigt then [fun a ->
                 AbsValSet.mapl
                   (function AVerkey (l,b) ->
                        List.map (fun t -> ASignature (AVerkey (l,b),t))
                            (AbsValSet.elements (!is_sig (l,b)))
                     | AnyPubVal -> 
                        List.map (fun t -> ASignature (AnyPubVal,t))
                            (AbsValSet.elements (a msg))
                     | _ -> [] ) (a key) ]
          else []
        )
    in
    (absemop b (VVF (l,true,b)) vlist iconstrst (VL (l,true,b)) pt clhs) @
    (absemop b (VVF (l,false,b)) vlist iconstrs (VL (l,false,b)) pf clhs) @
    (match clhs with
        VL (_l,true,_b) when _l=l && _b=b ->
          [fun a -> (ODom.M.empty,
                    let aliv = a liv
                    and aicvar = a icvar
                    and aVP = a VP
                    in
                    if AbsValSet.mem Alive (snd (aliv)) &&
                    ((
                      (AbsValSet.mem AnyPubVal (ODom.find (aicvar) key)) &&
                      (AbsValSet.exists (
                        function ASignature (_,t) ->
                            AbsValSet.exists (equivp (snd (aVP)) t)
                              (ODom.find (aicvar) msg)
                          | AnyPubVal ->
                            AbsValSet.exists (equivp (snd (aVP)) AnyPubVal)
                              (ODom.find (aicvar) msg)
                          | _ -> false
                      ) (ODom.find (aicvar) sigt))
                    ) || (
                      AbsValSet.exists (
                        function AVerkey (ll,bb) ->
                          AbsValSet.exists ( fun t -> 
                            (AbsValSet.exists (
                              function ASignature (k2,t2) ->
                                (equivp (snd (aVP)) k2 (AVerkey (ll,bb))) &&
                                (equivp (snd (aVP)) t2 t)
                              | AnyPubVal -> equivp (snd (aVP)) AnyPubVal t
                              | _ -> false
                            ) (ODom.find (aicvar) sigt)) &&
                            (AbsValSet.exists (
                              equivp (snd (aVP)) t
                            ) (ODom.find (aicvar) msg))
                          ) (snd (a (VS (ll,bb))))
                        | _ -> false
                      ) (ODom.find (aicvar) key)
                    ))
                    then AbsValSet.singleton Alive
                    else AbsValSet.empty)]
      | VL (_l,false,_b) when _l=l && _b=b ->
          [fun a -> (ODom.M.empty,
                    if AbsValSet.mem Alive (snd (a liv))
                    then AbsValSet.singleton Alive
                    else AbsValSet.empty)]
      | VVI (_l,_b) when _l=l && _b=b -> [fun a -> a icvar]
      | VVF (_l,true,_b) when _l=l && _b=b ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,true,b))))
                  then makeoutgoing vlist iconstrst f a
                  else (ODom.M.empty, AbsValSet.empty))
                  [fun a -> a (VVI (l,b))]
      | VVF (_l,false,_b) when _l=l && _b=b ->
        List.map (fun f ->
                fun a -> if AbsValSet.mem Alive (snd (a (VL (l,false,b))))
                  then f a
                  else (ODom.M.empty, AbsValSet.empty))
                  [fun a -> a (VVI (l,b))]
      | _ -> [])
  )
| _ -> raise (Invalid_argument "call removeZI first")
and absemip b icvar vlist iconstrs liv (ipref,l,outproc) clhs =
  let spref = match ipref with
      IPSimple s -> s
    | IPReplic s -> s
  in match spref with
  PReceive (ach,xp,x) ->
    (absemop b (VVI (l,b)) (xp::x::vlist) iconstrs liv outproc clhs) @
    (match clhs with
        VVI (_l,_b) when _l=l && _b=b ->
        [fun a -> if AbsValSet.mem Alive (snd (a liv))
                  then ODom.add (ODom.add (a icvar) x
                        (if chantype ach = Secure || chantype ach = Authentic
                         then snd (a (VC ach))
                         else AbsValSet.singleton AnyPubVal) ) xp
                        (AbsValSet.singleton XP)
                  else (ODom.M.empty,AbsValSet.empty)]
      | _ -> [])
| PInput x ->
    (absemop b (VVI (l,b)) (x::vlist) iconstrs liv outproc clhs) @
    (match clhs with 
        VVI (_l,_b) when _l=l && _b=b ->
        [fun a -> if AbsValSet.mem Alive (snd (a liv))
                  then ODom.add (a icvar) x (AbsValSet.singleton XS)
                  else (ODom.M.empty,AbsValSet.empty)]
      | _ -> [] );;

let rec opvars proc b = match proc with
  PStop ipl -> List.concat (List.map (fun p -> ipvars p b) ipl)
| PII -> []
| PSend (ach,_,_,ipl) ->
   let ct = chantype ach
   in if ct = Secure || ct = Authentic
      then (VC ach) :: (opvars (PStop ipl) b)
      else opvars (PStop ipl) b
| POutput (_,ipl) -> opvars (PStop ipl) b
| PLet (l,asgn,pt,pf) -> [VL (l,true,b); VL (l,false,b); VVI (l,b);
                          VVF (l,false,b)] @
         (if (match asgn with
               ImmAsgn _ -> false
             | HndAsgn (_,e) -> (match e with
                                   PubDec _ -> true
                                 | _ -> false) )
         then [VVF (l,true,true::b); VVF (l,true,false::b)] @
              (opvars pt (true::b)) @ (opvars pt (false::b))
         else [VVF (l,true,b)] @ (opvars pt b) ) @ (opvars pf b) @
         (match asgn with
            ImmAsgn _ -> []
          | HndAsgn (_,e) -> (match e with
          			Keypair l -> [VE (l,b)]
          		      | SymKey (l,_) -> [VE (l,b)]
          		      | SKpair l -> [VS (l,b)]
          		      | _ -> [] ) )
| PIf (l,_,pt,pf) -> [VL (l,true,b); VL (l,false,b)] @
                     (opvars pt b) @ (opvars pf b)    
| _ -> raise (Invalid_argument "call removeZI first")
and ipvars (ipref,l,outproc) b = (VVI (l,b)) :: (opvars outproc b);;

let pvars proc =
  let vvv = opvars proc []
  in let rec nub = 
         function [] -> []
  	  | [_] as lx -> lx
  	  | x :: ((y :: _) as lx) -> if x=y then nub lx else x :: (nub lx)
  in VP :: VLStart :: VVStart :: (nub (List.sort Pervasives.compare vvv));;

let solveproto oproc =
  let syst'' = funion (
                funion 
                  (absemop [] VVStart [] (const []) VLStart oproc)
                  advpower )
                (function VLStart -> 
                       [fun _ -> (ODom.M.empty, AbsValSet.singleton Alive)]
                 | VVStart ->
                       [fun _ -> (ODom.M.empty, AbsValSet.empty)]
                 | _ -> [])
  and vars = pvars oproc
  in
(*  let syst' x = List.map (fun f -> fun a ->
  			  let res = f a in print_string ((string_of_cv x) ^ " must be geq " ^ (Pretty.sprint 75 (ODom.pretty () res))); print_newline (); res) (syst'' x) *)
  let syst' = syst''
  in
(*  let syst clhs = print_string ("A constraint for " ^ (string_of_cv clhs)); print_newline (); syst' clhs
  in  *)
  let syst = syst' in
  List.iter (fun c -> print_string ((string_of_cv c) ^ " has " ^ (string_of_int (List.length (syst c))) ^ " constraints"); print_newline() ) vars;
  Solver.solve syst vars;;

let showsol solu vars =
  List.map (fun x -> (x, (Solver.HT.find solu x))) vars;;

(*
let x = let pr2 = removeZI fstprot
   in showsol (solveproto pr2) (pvars pr2);;

let y = showsol (solveproto ns) (pvars ns);;
*)

(*
let solu = solveproto yahalom;;

let yorig = showsol solu (pvars yahalom);;

let () =
  let f (cv,avs) = print_newline();
  		   print_string ((string_of_cv cv) ^ " ->\n" ^
  		                  (Pretty.sprint 80 (ODom.pretty () avs)));
  		   print_newline ()
  in print_string "YAHALOM\n"; List.iter f yorig;;
*)

(*
let solu2 = solveproto ns;;

let yorig2 = showsol solu2 (pvars ns);;

let () =
  let f (cv,avs) = print_newline();
  		   print_string ((string_of_cv cv) ^ " ->\n" ^
  		                  (Pretty.sprint 80 (ODom.pretty () avs)));
  		   print_newline ()
  in print_string "NEEDHAM-SCHROEDER-LOWE\n"; List.iter f yorig2;;
*)
(*
let solu3 = solveproto nsorig;;

let yorig3 = showsol solu3 (pvars nsorig);;

let () =
  let f (cv,avs) = print_newline();
  		   print_string ((string_of_cv cv) ^ " ->\n" ^
  		                  (Pretty.sprint 80 (ODom.pretty () avs)));
  		   print_newline ()
  in print_string "NEEDHAM-SCHROEDER (original)\n"; List.iter f yorig3;;
*)

(*
let solu4 = solveproto otwayrees;;

let yorig4 = showsol solu4 (pvars otwayrees);;

let () =
  let f (cv,avs) = print_newline();
  		   print_string ((string_of_cv cv) ^ " ->\n" ^
  		                  (Pretty.sprint 80 (ODom.pretty () avs)));
  		   print_newline ()
  in print_string "OTWAY-REES\n"; List.iter f yorig4;;
*)

(*
let solu5 = solveproto banyahal;;

let yorig5 = showsol solu5 (pvars banyahal);;

let () =
  let f (cv,avs) = print_newline();
  		   print_string ((string_of_cv cv) ^ " ->\n" ^
  		                  (Pretty.sprint 75 (ODom.pretty () avs)));
  		   print_newline ()
  in print_string "BAN-modified YAHALOM\n"; List.iter f yorig5;;
*)

let solu6 = solveproto ns2;;

let yorig6 = showsol solu6 (pvars ns2);;

let () =
  let f (cv,avs) = print_newline();
  		   print_string ((string_of_cv cv) ^ " ->\n" ^
  		                  (Pretty.sprint 75 (ODom.pretty () avs)));
  		   print_newline ()
  in print_string "NS with signed public keys\n"; List.iter f yorig6;;
