module Make (Domain: Hashtbl.HashedType) =
struct
  module H = Hashtbl.Make(Domain)
  type key = Domain.t
  type 'a t = 'a H.t * 'a 

  let create size def = (H.create size, def)
  let find (map,def) key = try H.find map key with Not_found -> def
  let find_all (map,def) key = H.find_all map key @ [def]

  let copy (map,def) = (H.copy map, def)  (* NB! maybe default should be copied? *)

   (* and this is inheritance???   *)
  let lift f (map,_) = f map
  let clear x = lift H.clear x
  let add x = lift H.add x
  let remove x = lift H.remove x
  let replace x = lift H.replace x
  let mem x = lift H.mem x (* or const true??? *)
  let iter f = lift (H.iter f)
  let fold f = lift (H.fold f)
  let length x = lift H.length x
end

module type S =
  sig
    type key
    type 'a t
    val create: int -> 'a -> 'a t
    val clear: 'a t -> unit
    val copy: 'a t -> 'a t
    val add: 'a t -> key -> 'a -> unit
    val remove: 'a t -> key -> unit
    val find: 'a t -> key -> 'a
    val find_all: 'a t -> key -> 'a list
    val replace : 'a t -> key -> 'a -> unit
    val mem : 'a t -> key -> bool
    val iter: (key -> 'a -> unit) -> 'a t -> unit
    val fold: (key -> 'a -> 'b -> 'b) -> 'a t -> 'b -> 'b
    val length: 'a t -> int
  end
